/* --------------------------------------------------------------
  UrlParser.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

export default {
	/**
	 * Get the value of a GET parameter.
	 *
	 * Since StyleEdit3 JS code will only be configured by the URL it's necessary
	 * to be a way of getting the GET parameters of the current request.Use this
	 * method to get variable values.
	 *
	 * Important: If a parameter does not exist then the result will be an undefined
	 * object, otherwise if the parameter exist but has no value this method will return
	 * a null result.
	 *
	 * @param {String} name Variable name of the value.
	 *
	 * @return {String} Returns the value of the parameter.
	 */
	getParam(name) {
		const getParametersString = window.location.search.substr(1);
		const tokens = getParametersString.split('&');
		const getParameters = {};
		
		tokens.forEach(function(token) {
			const parameter = token.split('=');
			getParameters[parameter[0]] = parameter[1] || null;
		});
		
		return getParameters[name];
	}
}
